ccPGP = {};

ccPGP.loadKey = function(armored, success) {
    kbpgp.KeyManager.import_from_armored_pgp({ armored: armored }, function(err, key) {
                                                ccPGP.info(key, function(info) {
                                                           var pgpKey = CCPGPKey.keyUsingInfoAndArmoredAndContextKey(info, armored, key);
                                                           success(pgpKey);
                                                           })
                                             });
}

ccPGP.load = function(armored, finished) {
    kbpgp.KeyManager.import_from_armored_pgp({ armored: armored }, finished);
}

ccPGP.loadData = function(data, success) {
    msg = {
        body : data,
        raw : function() { return null }
    }
    kbpgp.KeyManager.import_from_pgp_message(
                                             { msg : msg },
                                             function(err, key) {
                                             console.log('Here');
                                             console.log(key);
                                             console.log(err);
                                                ccPGP.info(key, function(info) {
                                                        var pgpKey = CCPGPKey.keyUsingInfoAndArmoredAndContextKey(info, data, key);
                                                        success(pgpKey);
                                                        })
                                             });
}

ccPGP.info = function(key, success) {
    var info = {};
    
    // KeyManager -> PgpEngine -> KeyWrapper (Primary/Subkey) -> Pair (KeyMaterial) -> Pub/Priv
    
    var primary = key.primary; // KeyWrapper (Primary/Subkey)
    var keymat = key.get_all_pgp_key_materials();
    var pkeymat = keymat[0][0];
    var has_private = pkeymat.has_private() ? true : false;
    
    info.fingerprint = key.get_pgp_fingerprint().toString("hex");
    info.pgp_key_id = pkeymat.get_key_id().toString("hex");
    //info.short_id = key.get_pgp_short_key_id().toString("hex");
    info.flags = pkeymat.flags;
    info.type = primary.key.type;
    info.timestamp = pkeymat.timestamp;
    info.is_locked = pkeymat.is_locked();
    
    info.self_signed = pkeymat.is_self_signed();
    if (primary.key.pub.nbits) info.nbits = primary.key.pub.nbits();
    
    // userids: pkeymat.get_signed_userids()[0].userid.toString("utf8")
    
    info.subkeys = [];
    
    var subkeys = key.subkeys;
    var i;
    for (i = 0; i < subkeys.length; i++) {
        var subkeymat = keymat[i+1][0];
        var subinfo = {
        pgp_key_id: subkeymat.get_key_id().toString("hex"),
        flags: subkeymat.flags,
        timestamp: subkeymat.timestamp,
        type: subkeys[i].key.type
        };
        
        if (subkeys[i].key.pub.nbits) subinfo.nbits = subkeys[i].key.pub.nbits();
        
        info.subkeys.push(subinfo);
    }
    
    info.userids = [];
    var userids = key.get_userids_mark_primary();
    for (i = 0; i < userids.length; i++) {
        info.userids.push({
                          is_primary: userids[i].primary,
                          username: userids[i].get_username(),
                          email: userids[i].get_email(),
                          comment: userids[i].get_comment(),
                          //most_recent_sig: userids[i].most_recent_sig,
                          });
    }
    
    success(info);
};
